<?php
require_once 'config.php';

if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = 'جميع الحقول مطلوبة';
    } else {
        try {
            $conn = getDBConnection();
            
            $stmt = $conn->prepare("SELECT id, username, password, role FROM users WHERE username = ?");
            if ($stmt === false) {
                throw new Exception('Prepare failed: ' . $conn->error);
            }
            $stmt->bind_param('s', $username);
            $stmt->execute();
            $stmt->store_result();
            $stmt->bind_result($user_id, $user_name, $hashed_password, $role);
            $stmt->fetch();

            if ($stmt->num_rows > 0 && password_verify($password, $hashed_password)) {
                $_SESSION['user_id'] = $user_id;
                $_SESSION['username'] = $user_name;
                $_SESSION['role'] = 'admin';
                
                // Get user's email
                $stmt_email = $conn->prepare("SELECT email FROM users WHERE id = ?");
                if ($stmt_email === false) {
                    throw new Exception('Prepare email statement failed: ' . $conn->error);
                }
                $stmt_email->bind_param('i', $user_id);
                $stmt_email->execute();
                $stmt_email->bind_result($email);
                $stmt_email->fetch();
                $_SESSION['email'] = $email;
                $stmt_email->close();
                
                if ($_SESSION['role']) {
                    header('Location: admin/dashboard.php');
                } else {
                    header('Location: services.php');
                }
                exit();
            } else {
                $error = 'اسم المستخدم أو كلمة المرور غير صحيحة';
            }
            $stmt->close();
        } catch (mysqli_sql_exception $e) {
            $error = 'حدث خطأ أثناء تسجيل الدخول: ' . $e->getMessage();
        } finally {
            if (isset($conn) && $conn) {
                $conn->close();
            }
        }
    }
}

require_once 'header.php';
?>

<div class="row justify-content-center">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h3 class="text-center">تسجيل الدخول</h3>
            </div>
            <div class="card-body">
                <?php if ($error): ?>
                    <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                <?php endif; ?>

                <form method="POST" action="login.php">
                    <div class="mb-3">
                        <label for="username" class="form-label">اسم المستخدم</label>
                        <input type="text" class="form-control" id="username" name="username" placeholder="اسم المستخدم الخاص بك" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">كلمة المرور</label>
                        <input type="password" class="form-control" id="password" name="password" placeholder="كلمة المرور" required>
                    </div>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary" style="background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%); border: none;">تسجيل الدخول</button>
                    </div>
                </form>
                <div class="text-center mt-3">
                    <p>ليس لديك حساب؟ <a href="register.php">إنشاء حساب جديد</a></p>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 